<?php

/* -----------------------------------------------------------------
 * 	$Id: xajax.googletax.php 493 2015-09-15 21:38:30Z akausch $
 * 	Copyright (c) 2011-2021 commerce:SEO by Webdesign Erfurt
 * 	http://www.commerce-seo.de
 * ------------------------------------------------------------------
 * 	based on:
 * 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
 * 	(c) 2002-2003 osCommerce - www.oscommerce.com
 * 	(c) 2003     nextcommerce - www.nextcommerce.org
 * 	(c) 2005     xt:Commerce - www.xt-commerce.com
 * 	Released under the GNU General Public License
 * --------------------------------------------------------------- */
defined("_VALID_XTC") or die("Direct access to this location isn't allowed.");

$xajax->registerFunction('get_next_cat');
$xajax->registerFunction('get_next_cat_en');
$xajax->registerFunction('get_new_dropdown_de');
$xajax->registerFunction('get_new_dropdown_en');

include(DIR_WS_CLASSES . 'googleTaxonomyGerman.php');
$google = new googleTaxonomyGerman();

function get_new_dropdown_de() {
    global $google;
    $ajax = new xajaxResponse();
    // $ajax->alert('val: '."\n".$google);
    $c = '<div id="selection">' . xtc_draw_pull_down_menu('google', $google->get_dropdown_data(), '', 'style="width:90%" onchange="xajax_get_next_cat(this.value, \'\')"') . '</div>';
    $ajax->assign('google_taxonomy_de', 'innerHTML', $c);
    $ajax->append('google_taxonomy_de', 'innerHTML', '<input type="hidden" name="" value="" id="short_path" />');
    return $ajax;
}

function get_next_cat($value = '', $parent = '') {
    $ajax = new xajaxResponse();
    if (!empty($parent)) {
        $path = explode('|', $parent);
        $path[] = $value;
    } else {
        $path[] = $value;
	}

    if (sizeof($path) == 1) {
        $c .= '<div>' . drop_down('', $value, true) . xtc_draw_hidden_field('path_0', $value) . '</div>';
        $c .= '<div>' . drop_down($value) . '</div>';
    } else {
        $long = implode(' > ', $path);
        for ($i = 0; $i < sizeof($path); $i++) {
            $np .= ($i > 0 && $path[$i - 1] != '' ? ' > ' : '') . $path[$i - 1];
            $c .= '<div>' . drop_down(substr($np, strlen($path[$i - 1])), $path[$i], true) . '</div>';
        }
        if (drop_down($long, '', $id)) {
            $c .= '<div>' . drop_down($long, '', $id) . '</div>';
        }
    }
    $j = '$("#short_path").val("' . implode('|', $path) . '");';
    $j .= '$("#GOOGLE_MERCHANT").val("' . implode(' > ', $path) . '");';
    $ajax->script($j);
    $ajax->assign('selection', 'innerHTML', $c);

    return $ajax;
}

function drop_down($value = '', $default = '', $read_only = false) {
    global $google;
    $data = $google->get_dropdown_data($value);
    if (!empty($data)) {
        $d = xtc_draw_pull_down_menu('', $data, $default, ($read_only ? 'disabled="" ' : '') . 'style="width:90%" onchange="xajax_get_next_cat(this.value, $(\'#short_path\').val())"');
        return $d;
    }
    return false;
}
include(DIR_WS_CLASSES . 'googleTaxonomyEnglish.php');
$googleen = new googleTaxonomyEnglish();

function get_new_dropdown_en() {
    global $googleen;
    $ajax = new xajaxResponse();
    // $ajax->alert('val: '."\n".$google);
    $c = '<div id="selectionen">' . xtc_draw_pull_down_menu('googleen', $googleen->get_dropdown_data(), '', 'style="width:90%" onchange="xajax_get_next_cat_en(this.value, \'\')"') . '</div>';
    $ajax->assign('google_taxonomy_en', 'innerHTML', $c);
    $ajax->append('google_taxonomy_en', 'innerHTML', '<input type="hidden" name="" value="" id="short_path_en" />');
    return $ajax;
}

function get_next_cat_en($value = '', $parent = '') {
    $ajax = new xajaxResponse();
    if (!empty($parent)) {
        $path = explode('|', $parent);
        $path[] = $value;
    } else {
        $path[] = $value;
	}

    if (sizeof($path) == 1) {
        $c .= '<div>' . drop_down_en('', $value, true) . xtc_draw_hidden_field('path_0', $value) . '</div>';
        $c .= '<div>' . drop_down_en($value) . '</div>';
    } else {
        $long = implode(' > ', $path);
        for ($i = 0; $i < sizeof($path); $i++) {
            $np .= ($i > 0 && $path[$i - 1] != '' ? ' > ' : '') . $path[$i - 1];
            $c .= '<div>' . drop_down_en(substr($np, strlen($path[$i - 1])), $path[$i], true) . '</div>';
        }
        if (drop_down_en($long, '', $id)) {
            $c .= '<div>' . drop_down_en($long, '', $id) . '</div>';
        }
    }
    $j = '$("#short_path_en").val("' . implode('|', $path) . '");';
    $j .= '$("#GOOGLE_MERCHANTEN").val("' . implode(' > ', $path) . '");';
    $ajax->script($j);
    $ajax->assign('selectionen', 'innerHTML', $c);

    return $ajax;
}

function drop_down_en($value = '', $default = '', $read_only = false) {
    global $googleen;
    $data = $googleen->get_dropdown_data($value);
    if (!empty($data)) {
        $d = xtc_draw_pull_down_menu('', $data, $default, ($read_only ? 'disabled="" ' : '') . 'style="width:90%" onchange="xajax_get_next_cat_en(this.value, $(\'#short_path_en\').val())"');
        return $d;
    }
    return false;
}
